//
//  QualtricsNotificationAuthenticationScreenViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 04.03.23.
//

import UIKit
import Firebase

class QualtricsNotificationAuthenticationScreenViewController : UIViewController {
    
    @IBOutlet var continueButton: UIButton!
    
    
    @IBOutlet var informationTextLabel: UILabel!
    
    
    @IBOutlet var validationCodeLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // change font of top bar title
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        // change font of informationTextLabel
        informationTextLabel.font = Fonts.mediumFontWithSize(size: 16)
        informationTextLabel.textColor = Colors.greyColor
        
        validationCodeLabel.font = Fonts.mediumFontWithSize(size: 35)
        validationCodeLabel.textColor = Colors.carmine
        
        validationCodeLabel.text = validationCodePublic
        
        // style continue Button
        //continueButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        //Utilities.styleFilledButtonNewTransBlue(continueButton)
        // style agree Button
        continueButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        Utilities.styleFilledButtonAgreeConditionsEdged(continueButton)
        

        
     
    }
    
    
    @IBAction func continueButton(_ sender: Any) {
        let docRef = Firestore.firestore().collection(qualtricsOnlineBankingDBPublic).document("\(appPINPublic)")
        docRef.getDocument{(document, error) in
            if let document = document, document.exists {
                let fieldLockAppPIN_SurveyIncomplete = document.get("lockAppPIN_SurveyIncomplete") as! Bool
                lockAppPIN_SurveyIncompletePublic = fieldLockAppPIN_SurveyIncomplete
                print("Check whether lockAppPIN_SurveyIncomplete got \"true\": \(lockAppPIN_SurveyIncompletePublic)")
                
                print("### TEST 1")
            }
            else {
                print("Something went wrong. appPIN not found, even if it should exist, since the user is already logged in.")
                lockAppPIN_SurveyIncompletePublic = true
                
                print("### TEST 2")
            }
        }
        
        
        if lockAppPIN_SurveyIncompletePublic == false {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
            let tabBarController = storyboard.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
            
            self.view.window?.rootViewController = tabBarController
            self.view.window?.makeKeyAndVisible()
            //self.dismiss(animated: true, completion: nil)
            
            print("### TEST 3")
            
        // disable app login...
        } else {
            let alert = UIAlertController(title: "Qualtrics Umfrage", message: "Bitte fahren Sie zunächst mit der Umfrage im Browser fort. Anschließend können Sie die Light Trade App weiter nutzen.", preferredStyle: UIAlertController.Style.alert)

            // add an action (button)
            alert.addAction(UIAlertAction(title: "Verstanden", style: UIAlertAction.Style.default, handler: nil))
            
            print("### TEST 4")
        }
    }
    
}
